<?php

/********************************************************************************
 *
 *  No New Threads
 *  Author: Pratik Unadkat (crazy4cs)
 *  Copyright: © 2011 Pratik Unadkat (crazy4cs)
 *  
 *  Website: http://www.mybb-world.com
 *
 *  Any codes in this plugin are copyrighted and not allowed to be reproduced.
 * 
 *  Gives administrator ability to block certain usergroups to create
 *  new threads until they achieve specific amount of posts.
 *
 *  Update: v1.1 - Added in the errormessage how much posts user has and how 
 *  much more he requires to be able to post threads, and fixed some bugs.
 *
 ********************************************************************************/

if(!defined("IN_MYBB"))
	die("This file cannot be accessed directly.");

$plugins->add_hook("newthread_start", "nonewthreads");


function nonewthreads_info()
{
	return array(
		"name"			=> "هاك منع انشاء مواضيع",
		"description"	=> "يسمح لك بمنع مجموعة اعضاء معينه من انشاء مواضيع جديدة الا بعد عدد معين من المشاركات",
		"website"		=> "http://www.mybb-world.com",
		"version"		=> "1.2",
		"author"		=> "Pratik Unadkat (crazy4cs)",
		"authorsite"	=> "http://www.ubers.org",
		"compatibility"  => "16*",
		'guid'        => "de3b8197ccd4f7326c58a86b0dedbf32"
	);
}
function nonewthreads_activate()
{
	global $db;
	
$nonewthreads_settings = array(
		'name' => 'nonewthreads',
		'title' => 'هاك منع انشاء مواضيع',
		'description' => 'اعدادات الهاك.',
		'disporder' => '1',
		'isdefault' => 'no'
	);
	$db->insert_query('settinggroups',$nonewthreads_settings);
	$gid = $db->insert_id();
	
	$nonewthreads_enabled = array(
		'name' => 'nonewthreads_enabled',
		'title' => 'تفعيل / ايقاف',
		'description' => 'تستطيع تفعيل او ايقاف الهاك من هنا.',
		'optionscode' => 'yesno',
		'value' => '0',
		'disporder' => '2',
		'gid' => intval($gid)
	);
	$db->insert_query('settings',$nonewthreads_enabled);

	$nonewthreads_posts = array(
		"name" => "nonewthreads_posts",
		"title" => "الجد الادني للمشاركات",
		"description" => "عدد المشاركات المطلوب لكي يستطيع العضو انشاء مواضيع.",
		"optionscode" => "text",
		"value" => "",
		"disporder" => "3",
		"gid" => intval($gid),
		);
	$db->insert_query("settings", $nonewthreads_posts);

     $nonewthreads_gid = array(
		"name" => "nonewthreads_gid",
		"title" => "المجموعات المسموح لها.",
		"description" => "ادخل هنا ارقام المجموعات التي تستطيع تجاوز الحد الادني للمشاركات ويستطيعو انشاء مواضيع ",
		"optionscode" => "text",
		"value" => "",
		"disporder" => "4",
		"gid" => intval($gid),
		);
	$db->insert_query("settings", $nonewthreads_gid);
	
	$nonewthreads_forums = array(
		"name" => "nonewthreads_forums",
		"title" => "الاقسام المتاحه",
		"description" => "ادخل هنا ارقام الاقسام المسموح بانشاء مواضيع بها بدون اي قيود",
		"optionscode" => "text",
		"value" => "",
		"disporder" => "5",
		"gid" => intval($gid),
		);
	$db->insert_query("settings", $nonewthreads_forums);
	
	
rebuild_settings();
}

function nonewthreads_deactivate()
{
	global $db;

$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='nonewthreads'");
$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='nonewthreads_enabled'");
$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='nonewthreads_gid'");		
$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='nonewthreads_posts'");	
$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='nonewthreads_forums'");

rebuild_settings();
}
	

function nonewthreads()	
{
global $fid, $forums, $mybb, $db, $nonewthreads;	

$nntgid = $mybb->settings['nonewthreads_gid'];
$nntposts = $mybb->settings['nonewthreads_posts'];
$nntforums = $mybb->settings['nonewthreads_forums'];
$pcount = $mybb->user['postnum'];
$preq = $nntposts - $pcount;
	
if($mybb->settings['nonewthreads_enabled'] == 1)
{
if($mybb->user['postnum'] < $mybb->settings['nonewthreads_posts'] && $fid != $mybb->settings['nonewthreads_forums'] && $mybb->user['usergroup'] != $mybb->settings['nonewthreads_gid'])
{
	error("لا يمكن انشاء مواضيع يتطلب يكون لديك عدد <strong>{$mybb->settings['nonewthreads_posts']}</strong> مشاركة. لديك الان <strong>{$pcount}</strong> مشاركة, والمطلوب <strong>{$preq}</strong> لكي تكون قادر علي انشاء مواضيع");
}

}
}
	
?>
